﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace tx_invoice_tutorial
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // the template is loaded immediately on starting the app

        private void Form1_Load(object sender, EventArgs e)
        {
            // LoadSettings are required to enable MS Word fields
            TXTextControl.LoadSettings ls = new TXTextControl.LoadSettings();
            ls.ApplicationFieldFormat = TXTextControl.ApplicationFieldFormat.MSWord;

            // connect TextControl with MailMegre
            mailMerge1.TextComponent = textControl1;
            // load the template
            textControl1.Load("invoice.docx", TXTextControl.StreamType.WordprocessingML, ls);
        }

        private void createToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // load the abstracted data source
            DataSet ds = new DataSet();
            ds.ReadXml("invoice.xml");

            // set the blocks (invoice items, taxes)
            // the blocks are recognized automatically in the DataSet
            mailMerge1.MergeBlocks(ds);
            
            // set the merge data
            // the merge fields are recognized automatically
            mailMerge1.Merge(ds.Tables["invoice"], false);
        }
}
}
